% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agreement.R
\name{agreement}
\alias{agreement}
\title{Measure agreement between vistla trees}
\usage{
agreement(x, y = NULL, ..., method = "spearman", raw = FALSE)
}
\arguments{
\item{x}{a \code{vistla} object (first to compare) or a list of \code{vistla} objects (all to compare pairwise).}

\item{y}{a \code{vistla} object, second to compare, if \code{x} is a single object.}

\item{...}{ignored.}

\item{method}{correlation method to use for quantification.
See \code{\link{cor}} for possible values.}

\item{raw}{if \code{TRUE}, suppresses correlation calculation and output the raw aligned scores instead.}
}
\value{
Correlation matrix with score correlations between each pair of given vistla trees.
}
\description{
Measure agreement between vistla trees
}
\examples{
 data(chain)
 agreement(
  vistla(Y~.,data=chain),
  vistla(Y~.,data=chain[,sample(6)])
 )
}
