% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_simu.R
\name{plot.VTTRUEPS}
\alias{plot.VTTRUEPS}
\title{Plot true parameters}
\usage{
\method{plot}{VTTRUEPS}(x, draw.levels = NULL, draw.curves = 1:6,
  legends = NULL, ltys = c(1, 1, 2, 2, 2, 2), pch = 19:24,
  ylim = c(0, 1), cols = c("red", "blue", "brown", "black", "gray",
  "green"), add.legend = TRUE, ...)
}
\arguments{
\item{x}{A class \code{VTTRUEPS} matrix generated by \code{\link{vtScenario}}}

\item{draw.levels}{Select dose levels to draw. Default \code{NULL} draws all
levels.}

\item{draw.curves}{Indicate which curves to plot. The options are

\itemize{
\item{1:}{p: DLT risk rate}
\item{2:}{q: Response rate}
\item{3:}{\eqn{\theta_{00}}}
\item{4:}{\eqn{\theta_{01}}}
\item{5:}{\eqn{\theta_{10}}}
\item{6:}{\eqn{\theta_{11}}}
}

See \code{\link{visit}} for details.}

\item{legends}{Line legends}

\item{ltys}{Line types}

\item{pch}{Line PCH}

\item{ylim}{Y limits}

\item{cols}{Line colors}

\item{add.legend}{Include legends (TRUE) or not (FALSE)}

\item{...}{optional arguments for plot}
}
\description{
Plot true DLT risk rates and response rates.
}
\examples{
rst.sce <- vtScenario(tox = c(0.05, 0.05, 0.08),
                      res = c(0.2, 0.3, 0.5),
                      rho = 1)
plot(rst.sce, draw.levels = 1:2, draw.curves=1:6)

}
