% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_samples_fact_inputfile.R
\name{get_samples_fact_inputfile}
\alias{get_samples_fact_inputfile}
\title{Selects columns defined by characters varsample and varfactor from
a data.frame}
\usage{
get_samples_fact_inputfile(dataframe, varsample, varfactor)
}
\arguments{
\item{dataframe}{\code{data.frame} or \code{list} containing at least two
columns with column headings of data type \code{character}.Data must be
column wise ordered.}

\item{varsample}{column name of dependent variable in dataframe,
datatype \code{character}}

\item{varfactor}{column name of independent variable in dataframe, datatype
\code{character}}
}
\value{
selected columns, \code{sample}, \code{factor}, \code{name_of_sample}
(character string equaling varsample), \code{name_of_factor}
(character string equaling varsample)
}
\description{
Selects columns defined by characters \code{varsample} and \code{varfactor}
from \code{dataframe}, returns selected columns with their names.
}
\examples{
get_samples_fact_inputfile(trees, "Girth", "Height")

}
