% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_risktable.R
\name{get_risktable}
\alias{get_risktable}
\alias{get_risktable.survfit}
\alias{get_risktable.tidycuminc}
\title{Obtain risk tables for tables and plots}
\usage{
get_risktable(x, ...)

\method{get_risktable}{survfit}(
  x,
  times = NULL,
  statlist = "n.risk",
  label = NULL,
  group = c("strata", "statlist"),
  collapse = FALSE,
  ...
)

\method{get_risktable}{tidycuminc}(
  x,
  times = pretty(x$tidy$time, 10),
  statlist = "n.risk",
  label = NULL,
  group = c("strata", "statlist"),
  collapse = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{survfit} or \code{tidycuminc}}

\item{...}{other arguments passed on to the method}

\item{times}{Numeric vector indicating the times at which the risk set, censored subjects, events are calculated.}

\item{statlist}{Character vector indicating which summary data to present. Current choices are "n.risk" "n.event"
"n.censor", "cum.event", "cum.censor".
Default is "n.risk".}

\item{label}{Character vector with labels for the statlist. Default matches "n.risk" with "At risk", "n.event" with
"Events", "n.censor" with "Censored", "cum.event" with "Cum. Event", and "cum.censor" with "Cum. Censor".}

\item{group}{String indicating the grouping variable for the risk tables.
Current options are:
\itemize{
\item{"strata": groups the risk tables per stratum.
The \code{label} specifies the label within each risk table. The strata levels
are used for the titles of the risk tables. This is the default}
\item{"statlist": groups the risk tables per statlist.
The \code{label} specifies the title for each risk table. The strata levels
are used for labeling within each risk table.}
}
Default is "strata".}

\item{collapse}{Boolean, indicates whether to present the data overall.
Default is FALSE.}
}
\value{
return list of attributes the form the risk table i.e.
number of patients at risk per strata
}
\description{
Create a risk table from an object using an S3 method.
Currently, no default method is defined.
}
\seealso{
\code{\link[survival]{summary.survfit}}
}
