% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tableone.R
\name{get_tableone}
\alias{get_tableone}
\alias{get_tableone.default}
\title{Calculate summary statistics}
\usage{
get_tableone(
  data,
  strata = NULL,
  overall = TRUE,
  summary_function = summarize_short
)

\method{get_tableone}{default}(
  data,
  strata = NULL,
  overall = TRUE,
  summary_function = summarize_short
)
}
\arguments{
\item{data}{The dataset to summarize as dataframe or tibble}

\item{strata}{Stratifying/Grouping variable name(s) as character vector. If NULL, only overall results are returned}

\item{overall}{If TRUE, the summary statistics for the overall dataset are also calculated}

\item{summary_function}{A function defining summary statistics for numeric and categorical values}
}
\value{
A list of data specified summaries for all input variables.

object of class tableone. That is a list of data specified summaries
for all input variables.
}
\description{
S3 method for creating a table of summary statistics.
The summary statistics can be used for presentation in tables such as table one or baseline and demography tables.

The summary statistics estimated are conditional on the variable type: continuous, binary, categorical, etc.

By default the following summary stats are calculated:
\itemize{
\item Numeric variables: mean, min, 25th-percentile, median, 75th-percentile, maximum, standard deviation
\item Factor variables: proportion of each factor level in the overall dataset
\item Default: number of unique values and number of missing values
}
}
\details{
It is possible to provide your own summary function. Please have a loot at summary for inspiration.
}
\note{
All columns in the table will be summarized. If only some columns shall be used, please select only those
variables prior to creating the summary table by using dplyr::select()
}
\examples{

# Example using the ovarian data set

survival::ovarian \%>\%
  dplyr::select(-fustat) \%>\%
  dplyr::mutate(
    age_group = factor(
      dplyr::case_when(
        age <= 50 ~ "<= 50 years",
        age <= 60 ~ "<= 60 years",
        age <= 70 ~ "<= 70 years",
        TRUE ~ "> 70 years"
      )
    ),
    rx = factor(rx),
    ecog.ps = factor(ecog.ps)
  ) \%>\%
  dplyr::select(age, age_group, everything()) \%>\%
  visR::get_tableone()

# Examples using ADaM data

# display patients in an analysis set
adtte \%>\%
  dplyr::filter(SAFFL == "Y") \%>\%
  dplyr::select(TRTA) \%>\%
  visR::get_tableone()

## display overall summaries for demog
adtte \%>\%
  dplyr::filter(SAFFL == "Y") \%>\%
  dplyr::select(AGE, AGEGR1, SEX, RACE) \%>\%
  visR::get_tableone()

## By actual treatment
adtte \%>\%
  dplyr::filter(SAFFL == "Y") \%>\%
  dplyr::select(AGE, AGEGR1, SEX, RACE, TRTA ) \%>\%
  visR::get_tableone(strata = "TRTA")

## By actual treatment, without overall
adtte \%>\%
  dplyr::filter(SAFFL == "Y") \%>\%
  dplyr::select(AGE, AGEGR1, SEX, EVNTDESC, TRTA ) \%>\%
  visR::get_tableone(strata = "TRTA", overall = FALSE)

}
