% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visNetworkProxy.R
\name{visNetwork-shiny}
\alias{renderVisNetwork}
\alias{visNetwork-shiny}
\alias{visNetworkOutput}
\alias{visNetworkProxy}
\title{Shiny bindings for visNetwork}
\usage{
visNetworkOutput(outputId, width = "100\%", height = "400px")

renderVisNetwork(expr, env = parent.frame(), quoted = FALSE)

visNetworkProxy(shinyId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{outputId}{: output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended.}

\item{expr}{An expression that generates a visNetwork}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This 
is useful if you want to save an expression in a variable.}

\item{shinyId}{single-element character vector indicating the shiny output ID of the
network to modify}

\item{session}{the Shiny session object to which the map belongs; usually the
default value will suffice}
}
\description{
Output and render functions for using visNetwork within Shiny 
applications and interactive Rmd documents. With \code{visNetworkProxy}, 
you can update your network without redraw in shiny.
}
\details{
With \code{visNetworkProxy}, you can update your network and use various methods :
\itemize{
 \item{"all 'visNetwork' functons"}{ : \code{\link{visOptions}}, \code{\link{visNodes}}, \code{\link{visEdges}}, \code{\link{visPhysics}}, \code{\link{visEvents}}, ...}
 \item{\code{\link{visFocus}}}{ : Focus to one or more nodes}
 \item{\code{\link{visFit}}}{ : Set view on a set of nodes}
 \item{\code{\link{visUpdateNodes}}}{ : Update and add nodes}
 \item{\code{\link{visUpdateEdges}}}{ : Update and add edges}
 \item{\code{\link{visRemoveNodes}}}{ :Remove nodes}
 \item{\code{\link{visRemoveEdges}}}{ : Remove edges}
 \item{\code{\link{visSelectNodes}}}{ :Select nodes}
 \item{\code{\link{visSelectEdges}}}{ : Select edges}
 \item{\code{\link{visGetNodes}}}{ :Get nodes}
 \item{\code{\link{visGetEdges}}}{ : Get edges}
 \item{\code{\link{visSetSelection}}}{ : Select edges/nodes}
 \item{and also...}{ : \code{\link{visRedraw}}, \code{\link{visStabilize}}, \code{\link{visSetData}}, \code{\link{visGetPositions}},
 , \code{\link{visMoveNode}}, \code{\link{visUnselectAll}}}
}
}
\examples{
\dontrun{

# have a look to : 
shiny::runApp(system.file("shiny", package = "visNetwork"))

}
}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}

