% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visExport.R
\name{visExport}
\alias{visExport}
\title{Network export configuration}
\usage{
visExport(graph, type = "png", name = "network",
  label = paste0("Export as ", type), background = "#fff",
  float = "right", style = NULL, loadDependencies = TRUE)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{type}{: Type of export. One of "png" (default) or "jpeg"}

\item{name}{: name of imgage, default to "network"}

\item{label}{: Label on button, default to "Export as png/jpeg"}

\item{background}{: background color, default to white (#fff)}

\item{float}{: button postion, default to "right"}

\item{style}{: button css style.}

\item{loadDependencies}{/ Boolean. TRUE by default. Load libraries for export (fileSaver, Blob, canvastoBlob,html2canvas)}
}
\description{
Network export configuration. This function only work within shiny or a web browser (not in RStudio)
}
\examples{

nodes <- data.frame(id = 1:3, group = c("B", "A", "B"))
edges <- data.frame(from = c(1,2), to = c(2,3))

visNetwork(nodes, edges) \%>\%
 visGroups(groupname = "A", color = "red") \%>\%
 visGroups(groupname = "B", color = "lightblue") \%>\%
 visLegend()\%>\% visExport() 
 
visNetwork(nodes, edges) \%>\%
 visGroups(groupname = "A", color = "red") \%>\%
 visGroups(groupname = "B", color = "lightblue") \%>\%
 visLegend()\%>\% visExport(type = "jpeg", name = "export-network", 
   float = "left", label = "Save network", background = "purple", style= "") 
 
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}

