% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-statespace.R
\name{predict.statespace}
\alias{predict.statespace}
\title{Predict using a statespace object}
\usage{
\method{predict}{statespace}(
  object,
  newX,
  newy = NULL,
  online = TRUE,
  compute_smooth = FALSE,
  type = c("mean", "proba", "model"),
  ...
)
}
\arguments{
\item{object}{the statespace object}

\item{newX}{the design matrix in the prediction set}

\item{newy}{(default \code{NULL}) the variable of interest in the prediction set. If specified
it allows to use the state-space model in the online setting. Otherwise the prediction is
offline.}

\item{online}{(default \code{TRUE}) specifies if the prediction is made online, that is if
the observation at time t-1 is used to update the model before predicting at time t.}

\item{compute_smooth}{(default \code{FALSE}) specifies if Kalman Smoothing is also computed.}

\item{type}{type of prediction. Can be either
\describe{
\item{mean}{return the mean forecast.}
\item{proba}{return a probabilistic forecast (list containing estimation of the mean and
standard deviation).}
\item{model}{return the updated statespace object (containing also the forecasts).}
}}

\item{...}{additional parameters}
}
\value{
Depending on the type specified, the result is \cr
- a vector of mean forecast if \code{type='mean'}
- a list of two vectors, mean forecast and standard deviations if \code{type='proba'}
- a statespace object if \code{type='model'}
}
\description{
\code{predict.statespace} makes a prediction for a statespace object, in the offline or online
setting.
}
