% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshapescene.R
\name{reshape.scene}
\alias{reshape.scene}
\title{Reshape a scene by applying a cut off distance and recentering a TLS scene}
\usage{
reshape.scene(data, point, radius, shape, plot3d)
}
\arguments{
\item{data}{a data.frame containing the xyz coordinates of a TLS scene}

\item{point}{(optional) a vector containing the xyz coordinates of the scene center. If no point is provided the user had to interactively select a region of the point cloud}

\item{radius}{the scene radius. Default = 5}

\item{shape}{If = "2d" the cut off distance is applied on the x and y axes of the scene and the scene edge is a cylinder.
If = "3d" the cut off distance is applied on the three dimensions of the scene and the scene edge is a sphere. Default = "2d"}

\item{plot3d}{logical. If \emph{TRUE} a 3d plot of the result is provided.}
}
\value{
a dataframe containing the reshaped TLS scene
}
\description{
The \strong{reshape.scene} function enables reshaping a TLS scene at any time in the data preparation process. It enables application of a
cut off distance and recentering a TLS scene by providing a user defined scene center, or by allowing users to interactively select a region of the point cloud to be used as the scene center.
}
\examples{
\donttest{
library(viewshed3d)
data(TLSclass)

# when a point is provided, the scene is automatically reshaped
center=c(mean(TLSclass[,1]),mean(TLSclass[,2]),mean(TLSclass[,3]))
reshaped=reshape.scene(TLSclass,point = center,radius = 2, plot3d = TRUE)

# if no point is provided, the user has to select a region (draw a squared region with the
# right click) of the point cloud that will be used as the scene center
reshaped=reshape.scene(TLSclass,radius = 2, plot3d = TRUE)
}
}
