% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/video.R
\name{video}
\alias{video}
\title{Video Player}
\usage{
video(
  files,
  format = NULL,
  options = list(),
  seek_ping_rate = 1000,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{files}{A vector of file paths or URLs pointing}

\item{format}{An optional list of formats of \code{video}}

\item{options}{A named list of options to apply to the video. List of available options
available in Details}

\item{seek_ping_rate}{Number of milliseconds between each update of `input$\{id\}_seek` while playing. Default is
set to 1000. If set to 0, then `input$\{id\}_seek` will not exist.}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended. Use \code{NA} for it to use
the original video width/height.}

\item{elementId}{HTML id tag to be given to the video player element}
}
\value{
A shiny.tag containing all of the required options for a \code{videojs} JS object to be initialised in a shiny application.

On the server side there will be up to four additional objects available as inputs:
\describe{
\item{\code{\{id\}_playing}}{A logical value as to whether or not the \code{video} is playing audio}
\item{\code{\{id\}_seek}}{(If \code{seek_ping_rate > 0}) the current time of the track loaded}
\item{\code{\{id\}_duration}}{The duration of the track loaded}
}
}
\description{
A video player that can be embedded in HTML pages.
}
\details{
Here are some more common options to implement:
\describe{
\item{autoplay}{
  Whether or not the video will autoplay on load. NOTE: There is not a guarantee autoplay will work in the browser.
  \describe{
  \item{\code{FALSE}}{Default: Video won't autoplay}
  \item{\code{TRUE}}{Video will use browser's autoplay}
  \item{\code{"muted"}}{Will mute the video and then manually call \code{play()} on \code{loadstart()}. Likely to work on browsers}
  \item{\code{"play"}}{Will call \code{play()} on \code{loadstart()}, similar to browser autoplay}
  }
}
\item{controls}{
  Determines whether or not the player has controls that the user can interact with. By default
  \code{video} will include controls even if not specified in the options.
}
\item{poster}{
  A URL to an image that displays before the video begins playing.
  This is often a frame of the video or a custom title screen.
}
}

For a full list of available options check out \url{https://videojs.com/guides/options/}
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    title = "howler.js Player",
    video("https://vjs.zencdn.net/v/oceans.mp4")
  )

  server <- function(input, output) {
  }

  runShiny(ui, server)
}

}
