% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FileComparatorFactory.R
\name{create_comparator}
\alias{create_comparator}
\title{FileComparatorFactory.R}
\usage{
create_comparator(file1, file2)
}
\arguments{
\item{file1}{first file to compare}

\item{file2}{second file to compare}
}
\description{
Factory method for creating comparator instance based on the given two files.
}
\examples{

# instantiating the compared files
file1 <- "file1.rtf"
file2 <- "file2.rtf"

# instantiating the configuration
config <- Config$new()

# instantiating a new comparator instance for every comparison:
comparator <- verifyr2::create_comparator(file1, file2)

# calling the summary and details comparison methods
comparator$vrf_summary(config = config)
comparator$vrf_details(config = config)

}
