% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velox.R
\name{velox}
\alias{velox}
\title{Create a VeloxRaster object}
\usage{
velox(x, extent = NULL, res = NULL, crs = NULL)
}
\arguments{
\item{x}{A Raster* object, matrix, list of matrices, list of VeloxRaster objects,
or character string pointing to a GDAL-readable file.}

\item{extent}{An \code{extent} object or a numeric vector of length 4. Required if \code{x} is a matrix or list
of matrices, ignored otherwise.}

\item{res}{The x and y resolution of the raster as a numeric vector of length 2. Required if \code{x} is a matrix or list
of matrices, ignored otherwise.}

\item{crs}{Optional. A character string describing a projection and datum in the PROJ.4 format.
Ignored if \code{x} is a Raster* object.}
}
\value{
A VeloxRaster object.
}
\description{
\code{velox} creates a VeloxRaster object.
}
\details{
Creates a VeloxRaster object. Note that VeloxRaster objects are Reference Class objects and thus mutable.
Hence, the usual R copy on modify semantics do not apply.

Note that if \code{x} is a list of VeloxRasters, the \code{extent} and \code{crs} attributes are copied
from the first list element.
}
\examples{
## Create VeloxRaster from list of matrices
mat1 <- matrix(1:100, 10, 10)
mat2 <- matrix(100:1, 10, 10)
mat.ls <- list(mat1, mat2)
vx <- velox(mat.ls, extent=c(0,1,0,1), res=c(0.1,0.1), crs="+proj=longlat +datum=WGS84 +no_defs")

}

