% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_eea.R
\name{ef_eea}
\alias{ef_eea}
\title{Emissions factors from European European Environment Agency}
\usage{
ef_eea(
  category,
  fuel,
  segment,
  euro,
  tech,
  pol,
  mode,
  slope,
  load,
  speed,
  fcorr = rep(1, 8)
)
}
\arguments{
\item{category}{String: "PC" (Passenger Cars), "LCV" (Light Commercial Vehicles),
"TRUCKS" (Heavy Duty Trucks),
"BUS" (Buses) or "MC" (Motorcycles or L-Category as in EEA 2019).}

\item{fuel}{String;  "G", "G HY", "G PHEV G",
"G PHEV ELEC",  "D", "D PHEV D",
"D PHEV ELEC", "LPG BIFUEL LPG", "LPG BIFUEL G",
"CNG BIFUEL CNG", "CNG BIFUEL G", "D HY D",
"D HY ELEC", "CNG", "BIO D"}

\item{segment}{String for type of vehicle (try different, the function will show values).}

\item{euro}{String; euro standard:
"PRE", "IMPROVED CONVENTIONAL", "OPEN LOOP",
"ECE 15/00-01", "ECE 15/02", "ECE 15/03", "ECE 15/04".
"I", "II", "III", "IV", "V",
"VI A/B/C", "VI D", "VI D-TEMP", "VI D/E",
"EEV".}

\item{tech}{String; technology:
"DPF", "DPF With S/W Update", "DPF+SCR"
"EGR", "GDI", "GDI+GPF", "LNT+DPF", "PFI", "SCR".}

\item{pol}{String; "CO", "NOx", "NMHC" (VOC), "PM" (PM Exhaust), "EC", "CH4", "NH3", "N2O"}

\item{mode}{String; "Urban Peak", "Urban Off Peak", "Rural", "Highway", NA.}

\item{slope}{Numeric; 0.00, -0.06, -0.04, -0.02,  0.02,  0.04,  0.06, or NA}

\item{load}{Numeric; 0.0,0.5, 1.0 or NA}

\item{speed}{Numeric; optional numeric in km/h.}

\item{fcorr}{Numeric; Correction by fuel properties by euro technology.
See \code{\link{fuel_corr}}. The order from first to last is
"PRE", "I", "II", "III", "IV", "V", "VI", "or other VI. Default is 1}
}
\value{
Return a function depending of speed or numeric (g/km)
}
\description{
\code{\link{ef_cetesb}} returns a vector or data.frame of Brazilian emission factors.
}
\examples{
{
# ef_eea(category = "I DONT KNOW")
ef_eea(category = "PC",
fuel = "G",
segment = "Small",
euro = "I",
tech = NA,
pol = "CO",
mode = NA,
slope = 0,
load = 0)(10)
}
}
\keyword{emission}
\keyword{factors}
