% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_ldv_cold.R
\name{ef_ldv_cold}
\alias{ef_ldv_cold}
\title{Cold-Start Emissions factors for Light Duty Vehicles}
\usage{
ef_ldv_cold(v = "LDV", ta, cc, f, eu, p, k = 1,
  show.equation = FALSE)
}
\arguments{
\item{v}{Category vehicle:  "LDV"}

\item{ta}{Ambient temperature. Monthly men can be used}

\item{cc}{Size of engine in cc: "<=1400",  "1400_2000" or ">2000"}

\item{f}{Type of fuel: "G", "D" or "LPG"}

\item{eu}{Euro standard: "PRE", "I", "II", "III",  "IV", "V", "VI" or "VIc"}

\item{p}{Pollutant: "CO", "FC", "NOx", "HC" or "PM"}

\item{k}{Multiplication factor}

\item{show.equation}{Option to see or not the equation parameters}
}
\value{
an emission factor function which depends of the average speed V
and ambient temperature. g/km
}
\description{
This function returns speed functions which depends on ambient temperature
average speed. The emission factors comes from the guidelines  EMEP/EEA air pollutant
emission inventory guidebook
http://www.eea.europa.eu/themes/air/emep-eea-air-pollutant-emission-inventory-guidebook
}
\examples{
{
ef1 <- ef_ldv_cold(ta = 15, cc = "<=1400", f ="G", eu = "I", p = "CO")
ef1(10)
}
}
\keyword{cold}
\keyword{emission}
\keyword{factors}
