# TODO:   Methods for objects of class vegtable
# 
# Author: Miguel Alvarez
################################################################################

# Method for taxlist
setMethod("count_taxa", signature(object="vegtable"),
		function(object, level, include_lower=FALSE, ...) {
			concepts <- with(object@species@taxonNames,
					TaxonConceptID[match(object@samples$TaxonUsageID,
									TaxonUsageID)])
			if(!missing(level))
				if(!level %in% levels(object@species))
					stop("Value of argument 'level' is not a level in 'object'.")
			if(!missing(level) & include_lower) {
				concept_levels <- with(object@species@taxonRelations,
						as.integer(Level)[match(concepts, TaxonConceptID)])
				x <- which(levels(object@species) == level) - 1
				for(i in 1:x) {
					concepts[concept_levels == i] <-
							with(object@species@taxonRelations,
									Parent[match(concepts[concept_levels == i],
													TaxonConceptID)])
					concept_levels <- with(object@species@taxonRelations,
							as.integer(Level)[match(concepts, TaxonConceptID)])
				}
			}
			if(!missing(level)) {
				concept_levels <- with(object@species@taxonRelations,
						paste(Level)[match(concepts, TaxonConceptID)])
				concepts <- concepts[concept_levels == level]
			}
			return(length(unique(concepts)))
		}
)

# formula method
# Method for vegtable objects
setMethod("count_taxa", signature(object="formula"),
		function(object, data, include_lower=FALSE, suffix="_count",
				in_header=FALSE, ...) {
			data_in <- data
			nr_response <- attr(terms(object), "response")
			name_response <- as.character(object)[2]
			if(nr_response > 1)
				stop("More than one response in formula are not allowed.")
			if(nr_response == 1 & include_lower)
				data <- taxa2samples(data, name_response) else
				data <- taxa2samples(data)
			if(nr_response == 1) {
				concepts <- with(data@species@taxonNames,
						TaxonConceptID[match(data@samples$TaxonUsageID,
										TaxonUsageID)])
				concept_levels <- with(data@species@taxonRelations,
						as.integer(Level)[match(concepts, TaxonConceptID)])
				data@samples$TaxonUsageID[!concept_levels ==
								which(levels(data@species) == name_response)] <-
						NA
			}
			object <- as.formula(paste("TaxonUsageID ~",
							paste(attr(terms(object), "term.labels"),
									collapse=" + ")))
			if(all(is.na(data@samples$TaxonUsageID)))
				stop("No records for requested taxon rank.")
			data <- aggregate(object, data, function(x) length(unique(x)), ...)
			if(name_response == "ReleveID") name_response <- "taxa"
			colnames(data)[colnames(data) == "TaxonUsageID"] <-
					paste0(name_response, suffix)
			if(colnames(data)[1] != "ReleveID" & in_header)
				warning("'ReleveID' is not included as factor in formula")
			if(colnames(data)[1] == "ReleveID" & in_header) {
				data_in@header[,colnames(data)[2]] <- with(data_in@header,
						data[match(ReleveID, data$ReleveID),2])
				return(data_in)
			} else return(data)
		}
)
