% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/euclidean.dist.R
\name{euclidean.dist}
\alias{euclidean.dist}
\title{Euclidean distance between two covariance matrices}
\usage{
euclidean.dist(S1, S2)
}
\arguments{
\item{S1}{a variance-covariance matrix}

\item{S2}{a variance-covariance matrix}
}
\value{
Euclidean distance between S1 and S2 following Dryden et al. (2009).
}
\description{
Computes the Euclidean distance (Frobenius norm) between two variance-covariance matrices of same dimensions
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus")
PHEN <- as.matrix(Tropheus[which(names(Tropheus) == "X1"):which(names(Tropheus) == "Y19")])

# Procrustes superimposition
library("geomorph")
PHEN_array <- arrayspecs(PHEN, p = 19, k = 2)
phen.gpa <- gpagen(PHEN_array, print.progress = FALSE)
proc.coord <- two.d.array(phen.gpa$coords)

# Data reduction
phen.pca <- prcomp(proc.coord, rank. = 5, tol = sqrt(.Machine$double.eps))
pc.scores <- phen.pca$x

# Covariance matrix of each population
S.phen.pop <- cov.group(pc.scores, groups = Tropheus$POP.ID)

# Euclidean distance between the covariance matrices of 2 populations
# (IKA1 relative to IKS5)
dist.a1s5 <- euclidean.dist(S.phen.pop[, , "IKA1"], S.phen.pop[, , "IKS5"])

}
\references{
Dryden IL, Koloydenko A, Zhou D (2009)
Non-Euclidean statistics for covariance matrices, with applications to diffusion tensor imaging.
\emph{The Annals of Applied Statistics 3}:1102-1123.
\url{https://projecteuclid.org/euclid.aoas/1254773280}
}
