% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal.R
\name{vec_proxy_equal}
\alias{vec_proxy_equal}
\title{Equality proxy}
\usage{
vec_proxy_equal(x, ...)
}
\arguments{
\item{x}{A vector x.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A 1d atomic vector or a data frame.
}
\description{
Returns a proxy object (i.e. an atomic vector or data frame of atomic
vectors). For \link{vctr}s, this determines the behaviour of \code{==} and
\code{!=} (via \code{\link[=vec_equal]{vec_equal()}}); \code{\link[=unique]{unique()}}, \code{\link[=duplicated]{duplicated()}} (via
\code{\link[=vec_unique]{vec_unique()}} and \code{\link[=vec_duplicate_detect]{vec_duplicate_detect()}}); \code{\link[=is.na]{is.na()}} and \code{\link[=anyNA]{anyNA()}}
(via \code{\link[=vec_equal_na]{vec_equal_na()}}).
}
\details{
The default method calls \code{\link[=vec_proxy]{vec_proxy()}}, as the default underlying
vector data should be equal-able in most cases. If your class is
not equal-able, provide a \code{vec_proxy_equal()} method that throws an
error.

If the proxy for \code{x} is a data frame, \code{vec_proxy_equal()} is
recursively applied on all columns as well.
}
\section{Dependencies}{

\itemize{
\item \code{\link[=vec_proxy]{vec_proxy()}} called by default
}
}

\keyword{internal}
