% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faq.R
\name{faq-error-scalar-type}
\alias{faq-error-scalar-type}
\title{FAQ - Error: Input must be a vector}
\description{
This error occurs when a function expects a vector and gets a scalar
object instead. This commonly happens when some code attempts to assign
a scalar object as column in a data frame:\if{html}{\out{<div class="r">}}\preformatted{fn <- function() NULL
tibble::tibble(x = fn)
#> Error: All columns in a tibble must be vectors.
#> x Column `x` is a function.

fit <- lm(1:3 ~ 1)
tibble::tibble(x = fit)
#> Error: All columns in a tibble must be vectors.
#> x Column `x` is a `lm` object.
}\if{html}{\out{</div>}}
}
\section{Vectorness in base R and in the tidyverse}{
In base R, almost everything is a vector or behaves like a vector. In
the tidyverse we have chosen to be a bit stricter about what is
considered a vector. The main question we ask ourselves to decide on the
vectorness of a type is whether it makes sense to include that object as
a column in a data frame.

The main difference is that S3 lists are considered vectors by base R
but in the tidyverse that’s not the case by default:\if{html}{\out{<div class="r">}}\preformatted{fit <- lm(1:3 ~ 1)

typeof(fit)
#> [1] "list"
class(fit)
#> [1] "lm"

# S3 lists can be subset like a vector using base R:
fit[1:3]
#> $coefficients
#> (Intercept) 
#>           2 
#> 
#> $residuals
#>             1             2             3 
#> -1.000000e+00 -3.885781e-16  1.000000e+00 
#> 
#> $effects
#> (Intercept)                         
#>  -3.4641016   0.3660254   1.3660254

# But not in vctrs
vctrs::vec_slice(fit, 1:3)
#> Error: Input must be a vector, not a `lm` object.
}\if{html}{\out{</div>}}

Defused function calls are another (more esoteric) example:\if{html}{\out{<div class="r">}}\preformatted{call <- quote(foo(bar = TRUE, baz = FALSE))
call
#> foo(bar = TRUE, baz = FALSE)

# They can be subset like a vector using base R:
call[1:2]
#> foo(bar = TRUE)
lapply(call, function(x) x)
#> [[1]]
#> foo
#> 
#> $bar
#> [1] TRUE
#> 
#> $baz
#> [1] FALSE

# But not with vctrs:
vctrs::vec_slice(call, 1:2)
#> Error: Input must be a vector, not a call.
}\if{html}{\out{</div>}}
}

\section{I get a scalar type error but I think this is a bug}{
It’s possible the author of the class needs to do some work to declare
their class a vector. Consider reaching out to the author. We have
written a \link[=howto-faq-fix-scalar-type-error]{developer FAQ page} to
help them fix the issue.
}

