% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.mean1}
\alias{replicate.mean1}
\title{Compares and combines single mean in original and follow-up studies}
\usage{
replicate.mean1(alpha, m1, sd1, n1, m2, sd2, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{estimated mean in original study}

\item{sd1}{estimated SD in original study}

\item{n1}{sample size in original study}

\item{m2}{estimated mean in follow-up study}

\item{sd2}{estimated SD in follow-up study}

\item{n2}{sample size for in follow-up study}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the difference in means
\item Row 4 estimates the average mean
}

The columns are:
\itemize{
\item Estimate - mean estimate (single study, difference, average)
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item df - degrees of freedom
}
}
\description{
This function computes confidence intervals for a single mean from an
original study and a follow-up study. Confidence intervals for the
difference between the two means and average of the two means are also
computed. Equality of variances across studies is not assumed. A
Satterthwaite adjustment to the degrees of freedom is used to improve
the accuracy of the confidence intervals for the difference and average.
The same results can be obtained using the \link[vcmeta]{meta.lc.mean1}
function with appropriate contrast coefficients. The confidence level
for the difference is 1 – 2*alpha, which is recommended for equivalence
testing.
}
\examples{
replicate.mean1(.05, 21.9, 3.82, 40, 25.2, 3.98, 75)

# Should return:
#                       Estimate        SE        LL        UL       df
# Original:                21.90 0.6039950 20.678305 23.121695 39.00000
# Follow-up:               25.20 0.4595708 24.284285 26.115715 74.00000
# Original - Follow-up:    -3.30 0.7589567 -4.562527 -2.037473 82.63282
# Average:                 23.55 0.3794784 22.795183 24.304817 82.63282


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
