% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.sub.pbcor}
\alias{meta.sub.pbcor}
\title{Confidence interval for a difference in average point-biserial
correlations for two sets of studies}
\usage{
meta.sub.pbcor(alpha, m1, m2, sd1, sd2, n1, n2, type, group)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of sample means for group 1}

\item{m2}{vector of sample means for group 2}

\item{sd1}{vector of sample SDs for group 1}

\item{sd2}{vector of sample SDs for group 2}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{type}{\itemize{
\item set to 1 for weighted variance
\item set to 2 for unweighted variance
}}

\item{group}{vector of group indicators:
\itemize{
\item 1 for set A
\item 2 for set B
\item 0 to ignore
}}
}
\value{
Returns a matrix with three rows:
\itemize{
\item Row 1 - Estimate for Set A
\item Row 2 - Estimate for Set B
\item Row 3 - Estimate for difference, Set A - Set B
}

The columns are:
\itemize{
\item Estimate - estimate of average correlation or difference
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
difference in average point-biserial correlations for two mutually
exclusive sets of studies. Each set can have one or more studies. Two
types of point-biserial correlations can be analyzed. One type uses
an unweighted variance and is approrpaite for 2-group experimental
designs. The other type uses a weighted variance and is appropriate
for 2-group nonexperimental designs with simple random sampling.
Equal variances within or across studies is not assumed.
}
\examples{
m1 <- c(45.1, 39.2, 36.3, 34.5)
m2 <- c(30.0, 35.1, 35.3, 36.2)
sd1 <- c(10.7, 10.5, 9.4, 11.5)
sd2 <- c(12.3, 12.0, 10.4, 9.6)
n1 <- c(40, 20, 50, 25)
n2 <- c(40, 20, 48, 26)
group <- c(1, 1, 2, 2)
meta.sub.pbcor(.05,  m1, m2, sd1, sd2, n1, n2, 2, group)

# Should return:
#                   Estimate         SE         LL        UL
# Set A:          0.36338772 0.08552728  0.1854777 0.5182304
# Set B:         -0.01480511 0.08741322 -0.1840491 0.1552914
# Set A - Set B:  0.37819284 0.12229467  0.1320530 0.6075828


}
\references{
\insertRef{Bonett2020b}{vcmeta}
}
