% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_functions.R
\name{prep_par_output}
\alias{prep_par_output}
\title{Preparation of Parameter Output}
\usage{
prep_par_output(output_par, Sigma_final, Rstruct, profileLik, X, y, H, q)
}
\arguments{
\item{output_par}{(\code{numeric}) \cr Found optimal value of
\code{\link[stats]{optim}}.}

\item{Sigma_final}{(\code{spam} or \code{matrix(n, n)}) \cr Covariance matrix
Sigma of SVC under final covariance parameters.}

\item{Rstruct}{(\code{NULL} or \code{spam.chol.NgPeyton}) \cr If
covariance tapering is used, the Cholesky factor has been calculated
previously and can be used to efficiently update the Cholesky factor of
\code{Sigma_final}, which is an \code{spam} object.}

\item{profileLik}{(\code{logical(1)}) \cr Indicates if optimization has been
conducted over full or profile likelihood.}

\item{X}{(\code{matrix(n, p)}) Design matrix}

\item{y}{(\code{numeric(p)}) Response vector}

\item{H}{(\code{NULL} or \code{matrix}) Hessian of MLE}

\item{q}{(\code{numeric(1)}) Number of SVC}
}
\value{
A \code{list} with two \code{data.frame}. Each contains the estimated
parameters with their standard errors of the fixed and random effects,
respectively.
}
\description{
Prepares and computes the ML estimates and their respective standard errors.
}
