"A" <-
function(x){
  if(!(class(x)=="varest")){
    stop("\nPlease provide an object of class 'varest', generated by 'var()'.\n")
  }
  K <- x$K
  p <- x$p
  type <- x$type
  A <- switch(type,
              "const" = B(x)[, -1],
              "trend" = B(x)[, -1],
              "both" = B(x)[, -c(1, 2)],
              "none" = B(x),
              {
                warning("type must be 'const', 'trend', 'both' or 'none'.")
                NULL
              })
  As <- list()
  start <- seq(1, p * K, K)
  end <- seq(K, p * K, K)
  for(i in 1 : p){
    As[[i]] <- matrix(A[, start[i] : end[i]], nrow=K, ncol=K)
    rownames(As[[i]]) <- rownames(A)
    colnames(As[[i]]) <- colnames(A[, start[i] : end[i]])
  }
  return(As)
}
