% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour-gdal-library.R
\name{vapour_gdal_version}
\alias{vapour_gdal_version}
\alias{vapour_all_drivers}
\alias{vapour_driver}
\alias{vapour_proj_version}
\title{GDAL version and drivers.}
\usage{
vapour_gdal_version()

vapour_proj_version()

vapour_all_drivers()

vapour_driver(dsource)
}
\arguments{
\item{dsource}{data source string (i.e. file name or URL or database connection string)}
}
\value{
please see Details, character vectors or lists of character vectors
}
\description{
Return information about the GDAL library in use.
}
\details{
\code{vapour_gdal_version} returns the version of GDAL as a string. This corresponds to the "--version"
as described for "GDALVersionInfo". \href{https://gdal.org/}{GDAL documentation}.

\code{vapour_all_drivers} returns the names and capabilities of all available drivers, in a list. This contains:
\itemize{
\item \code{driver} the driver (short) name
\item \code{name} the (long) description name
\item \code{vector} logical vector indicating a vector driver
\item \code{raster} logical vector indicating a raster driver
\item \code{create} driver can create (note vapour provides no write capacity)
\item \code{copy}   driver can copy (note vapour provides no write capacity)
\item \code{virtual} driver has virtual capabilities ('vsi')
}

\code{vapour_driver()} returns the short name of the driver, e.g. 'GPKG' or 'GTiff', to get the
long name and other properties use \code{vapour_all_drivers()} and match on 'driver'.
}
\examples{
vapour_gdal_version()

drv <- vapour_all_drivers()

f <- system.file("extdata/sst_c.fgb", package = "vapour")
vapour_driver(f)

as.data.frame(drv)[match(vapour_driver(f), drv$driver), ]
}
