% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{ProtHetWatIndices}
\alias{ProtHetWatIndices}
\title{Protein, HET, and Water Atom Indices}
\usage{
ProtHetWatIndices(data)
}
\arguments{
\item{data}{The atom data.frame of the PDB read into the \code{R} session
using the function \code{\link[bio3d:read.pdb]{bio3d::read.pdb()}}.}
}
\value{
Individual vectors for the indices of the protein, HET-atom, and
water atoms for a PDB file.
}
\description{
Indices for the protein, HET-atom, and water atoms
}
\details{
Returns individual numerical vectors for the protein, HET-atom, and
water atoms from the atom \code{\link[base:data.frame]{base::data.frame()}} of a PDB.

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
  ProtHetWatIndices(thrombin.1hai$atom[c(1:10, 2341:2350, 2385:2394), ])
  # $prot.idc
  # [1]  1  2  3  4  5  6  7  8  9 10
  #
  # $het.idc
  # [1] 11 12 13 14 15 16 17 18 19 20
  #
  # $h2o.idc
  # [1] 21 22 23 24 25 26 27 28 29 30
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{utilities}
