% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{ExtractPDBids}
\alias{ExtractPDBids}
\title{Extract PDB IDs}
\usage{
ExtractPDBids(pdb.location)
}
\arguments{
\item{pdb.location}{A collection of string values with the complete
(normalized) path for each PDB file within the provided directory/folder
obtained with the \code{\link[=ReturnPDBfullPath]{ReturnPDBfullPath()}}.}
}
\value{
a vector of strings containing the PDB identifiers for the protein
structures
}
\description{
Extract the four (4) character PDB identifier from the file name
}
\details{
The first four (4) characters of the file name -- typically the PDB
ID is placed at the beginning of the file name -- are extracted and assumed
to be the unique PDB ID.

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
  ExtractPDBids("1hai.pdb")
  # [1] "1hai"
  ExtractPDBids("/home/someuser/pdbs/1hai.pdb")
  # [1] "1hai"
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{FileTimeStamp}}, \code{\link{HasXWaters}},
  \code{\link{Nearby}}, \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{utilities}
