% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valuemap.R
\name{valuemap}
\alias{valuemap}
\title{Making choropleth map with sf polygons}
\usage{
valuemap(
  data,
  map = providers$OpenStreetMap,
  legend.cut = NULL,
  palette = "Blues",
  show.text = TRUE,
  text.color = "black",
  text.format = function(x) x
)
}
\arguments{
\item{data}{A sf object with polygons who has "name" & "value" columns ("value" column must be numeric type)}

\item{map}{A map name of leaflet::providers}

\item{legend.cut}{A numeric vector which means color legend boundary values}

\item{palette}{A color name of RColorBrewer palettes}

\item{show.text}{A boolean who determines showing "value" number on center of polygons}

\item{text.color}{A color name for "value" number text on center of polygons}

\item{text.format}{A format function for "value" number text on center of polygons}
}
\value{
A leaflet object.
}
\description{
This function make a leaflet object.
You can easily visualize your sf polygons based on "value" column.
You have options :
  background map (= map)
  color legend boundary values (= legend.cut)
  color palette for color legend (= palette)
  showing "value" number on center of polygons (= show.text)
  color for "value" number text on center of polygons (= text.color)
}
\examples{
# Only run this example in interactive R sessions
if (interactive()) valuemap(seoul)

# Emphasize great of equal to 20 polygons
if (interactive()) valuemap(seoul, legend.cut=c(20))

# Visualize without center number on polygons
if (interactive()) valuemap(seoul, legend.cut=c(15,17,20), show.text=FALSE)

# Change color palette & center number on polygons text color, format & change background map
if (interactive())
  valuemap(
    seoul, map=providers$Stamen.Toner, palette='YlOrRd',
    text.color='blue', text.format=function(x) paste(x,'EA')
  )
}
