% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_map.r
\name{bed_map}
\alias{bed_map}
\alias{concat}
\alias{values_unique}
\alias{values}
\title{Calculate summaries and statistics from overlapping intervals.}
\usage{
bed_map(x, y, ..., invert = FALSE, suffix = c(".x", ".y"),
  min_overlap = 1)

concat(.data, sep = ",")

values_unique(.data, sep = ",")

values(.data, sep = ",")
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{y}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{...}{name-value pairs specifying colnames and expressions to apply}

\item{invert}{report \code{x} intervals not in \code{y}}

\item{suffix}{colname suffixes in output}

\item{min_overlap}{minimum overlap for intervals.}

\item{.data}{data}

\item{sep}{separator character}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}}
}
\description{
Used to apply functions like \code{\link[=min]{min()}}, \code{\link[=count]{count()}},
\code{\link[=concat]{concat()}} to intersecting intervals. Book-ended intervals are
not reported by default, but can be included by setting \code{min_overlap =
0}.
}
\details{
input tbls are grouped by \code{chrom} by default, and additional
groups can be added using \code{\link[dplyr:group_by]{dplyr::group_by()}}. For example,
grouping by \code{strand} will constrain analyses to the same strand. To
compare opposing strands across two tbls, strands on the \code{y} tbl can
first be inverted using \code{\link[=flip_strands]{flip_strands()}}.
}
\examples{
x <- trbl_interval(
  ~chrom, ~start, ~end,
  'chr1',      1,      100
)

y <- trbl_interval(
  ~chrom, ~start, ~end, ~value,
  'chr1',      1,     20,    10,
  'chr1',      30,    50,    20,
  'chr1',      90,    120,   30
)

bed_glyph(bed_map(x, y, value = sum(value)), label = 'value')

x <- trbl_interval(
 ~chrom, ~start, ~end,
 "chr1", 100,    250,
 "chr2", 250,    500
)

y <- trbl_interval(
 ~chrom, ~start, ~end, ~value,
 "chr1", 100,    250,  10,
 "chr1", 150,    250,  20,
 "chr2", 250,    500,  500
)

# also mean, median, sd etc
bed_map(x, y, .sum = sum(value))

bed_map(x, y, .min = min(value), .max = max(value))

bed_map(x, y, .concat = concat(value))

# can also create a list-col
bed_map(x, y, .values = tibble::tibble(value))

# can also use `nth` family from dplyr
bed_map(x, y, .first = dplyr::first(value))

bed_map(x, y, .last = dplyr::last(value))

bed_map(x, y, .absmax = abs(max(value)))

bed_map(x, y, .absmin = abs(min(value)))

bed_map(x, y, .count = length(value))

bed_map(x, y, .count_distinct = length(unique(value)))

bed_map(x, y, .vals = values(value))

bed_map(x, y, .vals.unique = values_unique(value))

}
\seealso{
\url{http://bedtools.readthedocs.io/en/latest/content/tools/map.html}

Other multiple set operations: \code{\link{bed_closest}},
  \code{\link{bed_coverage}}, \code{\link{bed_intersect}},
  \code{\link{bed_subtract}}, \code{\link{bed_window}}
}
