context("redundancy")

test_that("trivial example works", {
  rules <- validator( rule1 = x > 1
                    , rule2 = x > 2
                    )
  
  # rule1 is superfluous
  rules_s <- remove_redundancy(rules)
  expect_equal(length(rules_s), 1)
  expect_equal(rules_s$rules[[1]]@expr, quote( x > 2))
  
  red <- detect_redundancy(rules)
  expect_equal(red, c(rule1 = TRUE, rule2 = FALSE))
})

test_that("double rule detection works", {
  
  rules <- validator( rule1 = x > 2
                    , rule2 = x > 2
  )
  
  rules_s <- remove_redundancy(rules)
  expect_equal(length(rules_s), 1)
  expect_equal(names(rules_s), "rule1")

  red <- detect_redundancy(rules)
  expect_equal(red, c(rule1 = TRUE, rule2 = TRUE))
})


test_that("equalities are allowed", {
  
  rules <- validator( profit == turnover - cost
                    , turnover > 0
                    , cost > 0
                    , cost >= 0.6 * turnover
  )
  
  rules_s <- remove_redundancy(rules)
  expect_equal(length(rules_s), 3)

  red <- detect_redundancy(rules)
  expect_equivalent(red, c(FALSE, FALSE, TRUE, FALSE))
})

test_that("conditional statements are allowed", {
  rules <- validator(x > 1,  y > 1,  if(x > 0) y > 0)
  are_redundant <- detect_redundancy(rules)
  #skip("Strange error: gives on travis a different result!")
  expect_equivalent(are_redundant, c(FALSE, FALSE, TRUE))
})
