% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R, R/expressionset.R
\name{label}
\alias{label}
\alias{label<-}
\alias{label,rule-method}
\alias{label<-,rule,character-method}
\alias{label,expressionset-method}
\alias{label<-,expressionset,character-method}
\title{Rule label}
\usage{
label(x, ...)

label(x) <- value

\S4method{label}{rule}(x, ...)

\S4method{label}{rule,character}(x) <- value

\S4method{label}{expressionset}(x, ...)

\S4method{label}{expressionset,character}(x) <- value
}
\arguments{
\item{x}{and R object}

\item{...}{Arguments to be passed to other methods}

\item{value}{Value to set}
}
\value{
A \code{character} vector.
}
\description{
A short (typically two or three word) description of a rule.
}
\examples{

# retrieve properties
v <- validator(turnover > 0, staff.costs>0)

# number of rules in v:
length(v)

# per-rule
created(v)
origin(v)
names(v)

# set properties
names(v)[1] <- "p1"

label(v)[1] <- "turnover positive"
description(v)[1] <- "
According to the official definition,
only positive values can be considered
valid turnovers.
"

# short description is also printed:
v

# print all info for first rule
v[[1]]



# retrieve properties
v <- validator(turnover > 0, staff.costs>0)

# number of rules in v:
length(v)

# per-rule
created(v)
origin(v)
names(v)

# set properties
names(v)[1] <- "p1"

label(v)[1] <- "turnover positive"
description(v)[1] <- "
According to the official definition,
only positive values can be considered
valid turnovers.
"

# short description is also printed:
v

# print all info for first rule
v[[1]]


}
\seealso{
Other expressionset-methods: 
\code{\link{as.data.frame,expressionset-method}},
\code{\link{as.data.frame}()},
\code{\link{created}()},
\code{\link{description}()},
\code{\link{meta}()},
\code{\link{names<-,rule,character-method}},
\code{\link{origin}()},
\code{\link{plot,validator-method}},
\code{\link{summary}()},
\code{\link{variables}()},
\code{\link{voptions}()}
}
\concept{expressionset-methods}
