#*  ----------------------------------------------------------------------------
#*  Copyright (C) 2011-2012 - Justin Lessler, Jessica Metcalf
#*  
#*  This program is free software; you can redistribute it and/or modify
#*  it under the terms of the GNU General Public License as published by
#*  the Free Software Foundation; version 2 of the License.
#*  
#*  This program is distributed in the hope that it will be useful,
#*  but WITHOUT ANY WARRANTY; without even the implied warranty of
#*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*  GNU General Public License for more details.
#*  
#*  You should have received a copy of the GNU General Public License
#*  along with this program; if not, write to the Free Software
#*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#*  
#*  $Id: vacem.r 391 2012-01-31 03:04:50Z ken $
#*  ----------------------------------------------------------------------------


##' A likelihood framework for estimating the effective coverage of vaccination
##' programs using cross-sectional surveys combined with administrative data.
##'
##' \tabular{ll}{ 
##'   Package:  \tab vacem\cr 
##'   Type:     \tab Package\cr 
##'   Version:  \tab 0.1-1\cr 
##'   Date:     \tab 2012-01-30\cr 
##'   License:  \tab GPL (>= 2)\cr 
##'   LazyLoad: \tab yes\cr 
##' } 
##'
##' The performance of routine and supplemental immunization activities is
##' usually measured by the administrative method: dividing the number of doses
##' distributed by the size of the target population. This package implements
##' a method that combines the administrative data with measurements from
##' cross-sectional surveys of vaccine coverage, e.g. Demographic and Health
##' Surveys (DHS), to provide an improved estimate of vaccination coverage.
##' 
##' @name vacem-package
##' @docType package 
##' @title Vaccination Activities Coverage Estimation Model
##' @author Justin Lessler \email{jlessler@@jhsph.edu}
##'         Jessica Metcalf \email{cmetcalf@@princeton.edu}
##' 
##' Maintainer: Ken Cline \email{kcline@@jhsph.edu}
##' 
##' @references Lessler J, Metcalf CJE, Grais RF, Luquero FJ, Cummings DAT,
##'             et al. (2011) Measuring the Performance of Vaccination Programs
##'             Using Cross-Sectional Surveys: A Likelihood Framework and
##'             Retrospective Analysis. PLoS Med 8(10): e1001110.
##'             doi:10.1371/journal.pmed.1001110
##'             \url{ http://www.plosmedicine.org/article/info:doi/10.1371/journal.pmed.1001110 }
##' 
##' @keywords vaccine immunization likelihood models
##' 
##' @examples 
##'   # TBD
##' 
##' 
NA
# TBD: 'NA' or 'NULL' or 'roxygen()' or 'vacem <- function () NULL' or ???





