% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{create_subset}
\alias{create_subset}
\title{Create a subset of a dataset}
\usage{
create_subset(mdata, rows, cols = NULL)
}
\arguments{
\item{mdata}{A mldr dataset}

\item{rows}{A vector with the instances indexes (names or indexes).}

\item{cols}{A vector with the attributes indexes (names or indexes).}
}
\value{
A new mldr subset
}
\description{
Create a subset of a dataset
}
\note{
It is not necessary specify the labels attributes because they are
 included by default.
}
\examples{
## Create a dataset with the 20 first examples and the 7 first attributes
small.toy <- create_subset(toyml, seq(20), seq(7))

## Create a random dataset with 50 examples and 5 attributes
random.toy <- create_subset(toyml, sample(100, 50), sample(10, 5))
}
\seealso{
Other sampling: 
\code{\link{create_holdout_partition}()},
\code{\link{create_kfold_partition}()},
\code{\link{create_random_subset}()}
}
\concept{sampling}
