% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{utiml_prepare_data}
\alias{utiml_prepare_data}
\title{Prepare a Transformed Multi-Label Data to be processed}
\usage{
utiml_prepare_data(dataset, classname, mldataset, mlmethod, base.method, ...)
}
\arguments{
\item{dataset}{A data.frame with the data (the last column must be the class
column)}

\item{classname}{The name of specific class of the object}

\item{mldataset}{The name of multi-label dataset}

\item{mlmethod}{The name of the multi-label method that will process this
dataset}

\item{base.method}{The name of the base method that will process this dataset}

\item{...}{Extra parameters for adding in the dataset object}
}
\value{
A \code{mltransformation} object. This is used as a list and
contains at least five values:
 \describe{
   \item{data}{A data.frame with the train data, where the columns are
   the attributes and the rows are the examples.}
   \item{labelname}{The name of the class column.}
   \item{labelindex}{The column index of the class.}
   \item{mldataset}{The name of multi-label dataset.}
   \item{mlmethod}{The name of the multi-label method.}
 }
}
\description{
Prepare a Transformed Multi-Label Data to be processed
}

