% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate.R
\name{tabulate_at_risk}
\alias{tabulate_at_risk}
\title{Tabulate At Risk}
\usage{
tabulate_at_risk(fit = NULL, times = NULL)
}
\arguments{
\item{fit}{Required. survival::survfit() object.}

\item{times}{Required. Numeric. One or vector of times to calculate for.}
}
\value{
Tibble risk table.
}
\description{
Returns a risk table from a model object and specified time points.
}
\examples{
library(survival)
fit <- survfit(Surv(time, status) ~ 1, data = diabetic)
tabulate_at_risk(fit, c(1, 3, 5))
}
