% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_row.R
\name{build_footer}
\alias{build_footer}
\title{build_footer}
\usage{
build_footer(.table = NULL, cols = NULL, by = NULL, data = NULL,
  parametric = FALSE)
}
\arguments{
\item{.table}{Optional. Tibble. A tibble to append row to.}

\item{cols}{Optional. Vector of characters. Column names summarized in table.
Used to determine appropriate types of summary stats. Defaults to considering
all columns in 'data'.}

\item{by}{Optional. Character. Name of factor or logical column table is stratified by.}

\item{data}{Required. Tibble. Contains data being summarized.}

\item{parametric}{Optional. Logical. Indicates parametric testing should be used for comparisons
(Fisher's exact and Student's Unpaired T-Test). Defaults to FALSE (non-parametric; Chi-squared and
Wilcox Rank-sum).}
}
\value{
Data is returned in the form of a tibble containing the row(s).
}
\description{
Creates a footer row specifying types of summary statistics. Does not
currently support "build_event" functions.
}
\examples{
library(dplyr)

data_mtcars <- datasets::mtcars \%>\%
  as_tibble() \%>\%
  mutate_at(vars('vs', 'am'), as.logical) \%>\%
  mutate_at(vars('gear', 'carb', 'cyl'), as.factor)

# Create footer row
build_footer(
  by = 'am',
  data = data_mtcars,
  parametric = FALSE
)
}
