% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{USL-class}
\alias{USL-class}
\title{Class "\code{USL}" for Universal Scalability Law models}
\description{
This class encapsulates the Universal Scalability Law. Use the function
\code{\link{usl}} to create new objects from this class.
}
\section{Slots}{

\describe{
\item{\code{frame}}{The model frame.}

\item{\code{call}}{The call used to create the model.}

\item{\code{regr}}{The name of the regressor variable.}

\item{\code{resp}}{The name of the response variable.}

\item{\code{coefficients}}{The coefficients alpha, beta and gamma of the model.}

\item{\code{coef.std.err}}{The standard errors for the coefficients alpha and beta.}

\item{\code{coef.names}}{A vector with the names of the coefficients.}

\item{\code{fitted}}{The fitted values of the model. This is a vector.}

\item{\code{residuals}}{The residuals of the model. This is a vector.}

\item{\code{df.residual}}{The degrees of freedom of the model.}

\item{\code{sigma}}{The residual standard deviation of the model.}

\item{\code{limit}}{The scalability limit as per Amdahl.}

\item{\code{peak}}{A vector with the predictor and response values of the peak.}

\item{\code{optimal}}{A vector with the optimal predictor and response values.}

\item{\code{efficiency}}{The efficiency, e.g. speedup per processor.}

\item{\code{na.action}}{The \code{na.action} used by the model.}
}}

\seealso{
\code{\link{usl}}
}
