% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github-labels.R
\name{use_github_labels}
\alias{use_github_labels}
\alias{use_tidy_labels}
\alias{tidy_labels}
\alias{tidy_labels_rename}
\alias{tidy_label_colours}
\alias{tidy_label_descriptions}
\title{Manage GitHub issue labels}
\usage{
use_github_labels(repo_spec = github_repo_spec(), labels = character(),
  rename = character(), colours = character(),
  descriptions = character(), delete_default = FALSE,
  auth_token = github_token(), host = NULL)

use_tidy_labels(repo_spec = github_repo_spec(),
  auth_token = github_token(), host = NULL)

tidy_labels()

tidy_labels_rename()

tidy_label_colours()

tidy_label_descriptions()
}
\arguments{
\item{repo_spec}{Optional repository specification (\code{owner/repo}) if you
don't want to target the current project.}

\item{labels}{A character vector giving labels to add.}

\item{rename}{A named vector with names giving old names and values giving
new values.}

\item{colours, descriptions}{Named character vectors giving hexadecimal
colours (like \code{e02a2a}) and longer descriptions. The names should match
label names, and anything unmatched will be left unchanged. If you
create a new label, and don't supply colours, it will be given a random
colour.}

\item{delete_default}{If \code{TRUE}, will remove GitHub default labels that do
not appear in the \code{labels} vector, and do not have associated issues.
to your workflow).}

\item{auth_token}{GitHub personal access token (PAT).}

\item{host}{GitHub API host to use. Override with the endpoint-root for your
GitHub enterprise instance, for example,
"https://github.hostname.com/api/v3".}
}
\description{
\code{use_github_labels()} can create new labels, update colours and descriptions,
and optionally delete GitHub's default labels (if \code{delete_default = TRUE}).
It will never delete labels that have associated issues.

\code{use_tidy_labels()} calls \code{use_github_labels()} with tidyverse conventions
powered by \code{tidy_labels()}, \code{tidy_labels_rename()}, \code{tidy_label_colours()} and
\code{tidy_label_descriptions()}.
}
\section{Label usage}{

Labels are used as part of the issue-triage process, designed to minimise the
time spent re-reading issues. The absence of a label indicates that an issue
is new, and has yet to be triaged.
\itemize{
\item \code{reprex} indicates that an issue does not have a minimal reproducible
example, and that a reply has been sent requesting one from the user.
\item \code{bug} type, indicates an unexpected problem or unintended behavior.
\item \code{feature} type, indicates a feature request or enhancement.
\item \code{docs} type, indicates an issue with the documentation.
\item \code{wip} indicates that someone else is working on it or has promised to.
\item \code{good first issue} indicates a good issue for first-time contributors.
\item \code{help wanted} indicates that a maintainer wants help on an issue.
}
}

\examples{
\dontrun{
# typical use in, e.g., a new tidyverse project
use_github_labels(delete_default = TRUE)

# create labels without changing colours/descriptions
use_github_labels(
  labels = c("foofy", "foofier", "foofiest"),
  colours = NULL,
  descriptions = NULL
)

# change descriptions without changing names/colours
use_github_labels(
  labels = NULL,
  colours = NULL,
  descriptions = c("foofiest" = "the foofiest issue you ever saw")
)
}
}
