% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{use_data}
\alias{use_data}
\alias{use_data_raw}
\title{Create package data}
\usage{
use_data(..., internal = FALSE, overwrite = FALSE,
  compress = "bzip2", version = 2)

use_data_raw(name = "DATASET", open = interactive())
}
\arguments{
\item{...}{Unquoted names of existing objects to save.}

\item{internal}{If \code{FALSE}, saves each object in its own \code{.rda}
file in the \code{data/} directory. These data files bypass the usual
export mechanism and are available whenever the package is loaded
(or via \code{\link[=data]{data()}} if \code{LazyData} is not true).

If \code{TRUE}, stores all objects in a single \code{R/sysdata.rda} file.
Objects in this file follow the usual export rules. Note that this means
they will be exported if you are using the common \code{exportPattern()}
rule which exports all objects except for those that start with \code{.}.}

\item{overwrite}{By default, \code{use_data()} will not overwrite existing
files. If you really want to do so, set this to \code{TRUE}.}

\item{compress}{Choose the type of compression used by \code{\link[=save]{save()}}.
Should be one of "gzip", "bzip2", or "xz".}

\item{version}{The serialization format version to use. The default, 2, was
the default format from R 1.4.0 to 3.5.3. Version 3 became the default from
R 3.6.0 and can only be read by R versions 3.5.0 and higher.}

\item{name}{Name of the dataset to be prepared for inclusion in the package.}

\item{open}{Open the newly created file for editing? Happens in RStudio, if
applicable, or via \code{\link[utils:file.edit]{utils::file.edit()}} otherwise.}
}
\description{
\code{use_data()} makes it easy to save package data in the correct format.
I recommend you save scripts that generate package data in \code{data-raw}:
use \code{use_data_raw()} to set it up.
}
\examples{
\dontrun{
x <- 1:10
y <- 1:100

use_data(x, y) # For external use
use_data(x, y, internal = TRUE) # For internal use
}
\dontrun{
use_data_raw("daisy")
}
}
\seealso{
The \href{http://r-pkgs.had.co.nz/data.html}{data chapter} of \href{http://r-pkgs.had.co.nz}{R Packages}.
}
