% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr.R
\name{pr.test}
\alias{pr.test}
\title{Compare two Precision-Recall curves}
\usage{
pr.test(
  labels,
  pred1,
  pred2,
  boot.n = 10000,
  boot.stratified = TRUE,
  alternative = "two.sided"
)
}
\arguments{
\item{labels}{\code{numeric()}\cr
Vector of responses/labels (only two classes/values allowed: cases/positive
class = 1 and controls/negative class = 0)}

\item{pred1}{\code{numeric()}\cr
Vector of prediction values. Higher values denote positive class.}

\item{pred2}{\code{numeric()}\cr
Vector of prediction values. Higher values denote positive class.
Must have the same length as \code{pred1}.}

\item{boot.n}{\code{numeric(1)}\cr
Number of bootstrap resamples. Default: 10000}

\item{boot.stratified}{\code{logical(1)}\cr
Whether the bootstrap resampling is stratified (same number of cases/controls
in each replicate as in the original sample) or not.
Advised to use especially when classes from \code{labels} are imbalanced.
Default: TRUE.}

\item{alternative}{\code{character(1)} \cr
Specifies the alternative hypothesis. Either "two.sided", "less" or "greater".
Default: "two.sided".}
}
\value{
a list with the AUCs of the two original prediction vectors and the
p-value of the bootstrap-based test.
}
\description{
Test the hypothesis that the true difference in PR AUCs is equal to 0.
We implement the same bootstrap method based on the idea from \code{\link[pROC:roc.test]{pROC::roc.test()}}.
The PR AUC is calculated using \code{\link[PRROC:pr.curve]{PRROC::pr.curve()}} with the interpolation
method of Davis (2006).
}
\examples{
set.seed(42)
# imbalanced labels
labels = sample(c(0,1), 20, replace = TRUE, prob = c(0.8,0.2))
# predictions
pred1 = rnorm(20)
pred2 = rnorm(20)
pr.test(labels, pred1, pred2, boot.n = 1000, boot.stratified = FALSE)
pr.test(labels, pred1, pred2, boot.n = 1000, boot.stratified = TRUE)

}
\references{
Davis J, Goadrich M (2006).
\dQuote{The relationship between precision-recall and ROC curves.}
\emph{Proceedings of the 23rd International Conference on Machine Learning}, \bold{148}(4), 233--240.
\doi{10.1145/1143844.1143874}.
}
