% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burndown.R
\name{storypoints_and_status_released}
\alias{storypoints_and_status_released}
\title{Calculate storypoints ans status of the Cards of a specific Board}
\usage{
storypoints_and_status_released(organisation, board_id, token)
}
\arguments{
\item{organisation}{A character. The name of the organisation as specified in the URL:
https://<organisation>.upwave.io}

\item{board_id}{An integer. The number of the board you want to inspect as specified in
the URL: https://<organisation>.upwave.io/board/<board_id>/view/}

\item{token}{A character. The API token to access boards on upwave.io. The token can be
obtained by visiting your account settings. Click your profile image, select "Settings"
and find your API-Key in the "Account" tab.}
}
\value{
A list containing a data.frame with all storypoints and the status per card and
the numeric sum_storypoints.
}
\description{
Calculates storypoints of released cards on a specific board
}
\examples{
upwaver::storypoints_and_status_released(
"4597", 14351, "807a0c3451c04602b4dbfdc0338a65f7")
}
