% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BootEstimation_for.R
\name{BootEstimation_for}
\alias{BootEstimation_for}
\title{Bootstrapping Estimation for Causal Mediation Effects via
Ordinary "for" Loop}
\usage{
BootEstimation_for (m_model, y_model, data, X, M, Y,
m_type, y_type, boot_num = 100)
}
\arguments{
\item{m_model}{a fitted model object for the mediator.}

\item{y_model}{a fitted model object for the outcome.}

\item{data}{a dataframe used in the analysis.}

\item{X}{a character variable of the exposure's name.}

\item{M}{a character variable of the mediator's name.}

\item{Y}{a character variable of the outcome's name.}

\item{m_type}{a character variable of the mediator's type.}

\item{y_type}{a character variable of the outcome's type.}

\item{boot_num}{the times of bootstrapping in the analysis. The default is 100.}
}
\value{
This function returns a list of three dataframes, i.e.,
the bootstrapping results of the mediation effects.
This list is also saved in the return of the main function \code{\link{FormalEstmed}}.
}
\description{
This function obtains the estimates of mediation effects by the ordinary \code{for} loop.
Through bootstrap sampling and repeating the algorithm of function \code{\link{SingleEstimation}},
This function obtains a number of estimates for each type of effect.

This is an internal function, automatically called by the function \code{\link{Statistics}}.
}
\details{
This function is realized by the ordinary \code{for} loop, therefore may take longer time to proceed.
For small amounts of data, e.g., dozens to a hundred samples, with relatively simple models,
\code{for} loop is recommended.
}
