% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{units}
\alias{units}
\alias{units<-.numeric}
\alias{units}
\alias{units<-.units}
\alias{units}
\alias{units<-.logical}
\alias{units}
\alias{units.units}
\title{Set measurement units on a numeric vector}
\usage{
\method{units}{numeric}(x) <- value

\method{units}{units}(x) <- value

\method{units}{logical}(x) <- value

\method{units}{units}(x)
}
\arguments{
\item{x}{numeric vector, or object of class \code{units}}

\item{value}{object of class \code{units} or \code{symbolic_units}, or in the case of \code{set_units} expression with symbols that can be resolved in \link{ud_units} (see examples).}
}
\value{
object of class \code{units}

the units method retrieves the units attribute, which is of class \code{symbolic_units}
}
\description{
Set measurement units on a numeric vector

Convert units

retrieve measurement units from \code{units} object
}
\details{
if \code{value} is of class \code{units} and has a value unequal to 1, this value is ignored unless \code{units_options("simplifiy")} is \code{TRUE}. If \code{simplify} is \code{TRUE}, \code{x} is multiplied by this value.
}
\examples{
x = 1:3
class(x)
units(x) <- as_units("m/s")
class(x)
y = 2:5
a <- with(ud_units, 1:3 * m/s)
units(a) <- with(ud_units, km/h)
a
}
