% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{methods-unitquantreg}
\alias{methods-unitquantreg}
\alias{print.unitquantreg}
\alias{summary.unitquantreg}
\alias{coef.unitquantreg}
\alias{vcov.unitquantreg}
\alias{logLik.unitquantreg}
\alias{confint.unitquantreg}
\alias{fitted.unitquantreg}
\alias{terms.unitquantreg}
\alias{model.frame.unitquantreg}
\alias{model.matrix.unitquantreg}
\alias{update.unitquantreg}
\alias{print.unitquantregs}
\alias{summary.unitquantregs}
\title{Methods for \code{unitquantreg} and \code{unitquantregs} objects}
\usage{
\method{print}{unitquantreg}(x, digits = max(4, getOption("digits") - 3), ...)

\method{summary}{unitquantreg}(object, correlation = FALSE, ...)

\method{coef}{unitquantreg}(object, type = c("full", "quantile", "shape"), ...)

\method{vcov}{unitquantreg}(object, ...)

\method{logLik}{unitquantreg}(object, ...)

\method{confint}{unitquantreg}(object, parm, level = 0.95, ...)

\method{fitted}{unitquantreg}(object, type = c("quantile", "shape", "full"), ...)

\method{terms}{unitquantreg}(x, type = c("quantile", "shape"), ...)

\method{model.frame}{unitquantreg}(formula, ...)

\method{model.matrix}{unitquantreg}(object, type = c("quantile", "shape"), ...)

\method{update}{unitquantreg}(object, formula., ..., evaluate = TRUE)

\method{print}{unitquantregs}(x, digits = max(3, getOption("digits") - 3), ...)

\method{summary}{unitquantregs}(object, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{digits}{minimal number of \emph{significant} digits.}

\item{...}{additional argument(s) for methods. Currently not used.}

\item{object, x}{fitted model object of class \code{\link{unitquantreg}}.}

\item{correlation}{logical; if \code{TRUE}, the correlation matrix of the estimated parameters is returned and printed. Default is \code{FALSE}.}

\item{type}{character indicating type of fitted values to return.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{formula}{an R formula.}

\item{formula.}{Changes to the formula see \code{\link{update.formula}} for details.}

\item{evaluate}{If true evaluate the new call else return the call.}
}
\value{
The \code{summary} method gives Wald tests for the regressions coefficients
based on the observed Fisher information matrix. As usual the \code{summary}
method returns a list with relevant model statistics and estimates, which
can be printed using the \code{print} method.

The \code{coef}, \code{vcov}, \code{confint} and \code{fitted} methods can
be use to extract, respectively, the estimated coefficients, the
estimated covariance matrix, the Wald confidence intervals, and fitted
values.

A \code{\link{logLik}} method is also provide, then the \code{\link{AIC}}
function can be use to calculated the Akaike Information Criterion.

The generic methods \code{\link{terms}}, \code{\link{model.frame}},
\code{\link{model.matrix}}, \code{\link{update}} and are also provided.
}
\description{
Methods for extracting information from fitted regression models
objects of class \code{unitquantreg} and \code{unitquantregs}.
}
\examples{
set.seed(6669)
n <- 200
betas <- c(1, 2)
gamas <- c(-1, 1)
X <- cbind(1, x1 = runif(n))
Z <- cbind(1, z1 = rexp(n))
eta <- drop(X \%*\% betas)
zeta <- drop(Z \%*\% gamas)
mu <- exp(eta) / (1 + exp(eta))
theta <- exp(zeta)
data_simulated <- data.frame(x1 = X[, 2], z1 = Z[, 2])
data_simulated$y <- ruweibull(n, mu, theta)

fit_1 <- unitquantreg(formula = y ~ x1 + z1 + I(x1^2) | z1 + x1,
                      data = data_simulated, family = "uweibull",
                      tau = 0.5, link.theta = "log")
fit_1
summary(fit_1)
vcov(fit_1)
coef(fit_1)
confint(fit_1)
terms(fit_1)
model.frame(fit_1)
model.matrix(fit_1)
update(fit_1, . ~ . -x1)
update(fit_1, . ~ . -z1)
update(fit_1, . ~ . -I(x1^2))
update(fit_1, . ~ . | . -z1)
update(fit_1, . ~ . | . -x1)

}
\author{
André F. B. Menezes
}
