% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{uni_bonn_2}
\alias{uni_bonn_2}
\title{Gradient colors of the University of Bonn}
\format{
An object of class \code{character} of length 12.
}
\source{
Color definitions are based on the 
\href{https://www.uni-bonn.de/de/universitaet/presse-kommunikation/corporate-design}{CD manual}.
}
\usage{
uni_bonn_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_bonn_2} provides 4 shades (of 100%, 75%, 50%, and 25%) 
for each of the 3 primary colors 
of the \href{https://www.uni-bonn.de/en}{University of Bonn}, Germany.
}
\details{
See \code{\link{uni_bonn_1}} for the definitions of the three primary colors 
and the \code{\link{ac}} and \code{\link{usecol}} functions 
for creating color gradients.
}
\examples{
uni_bonn_2
seecol(uni_bonn_2, main = "Gradient colors of the University of Bonn")  # view color palette 
demopal(uni_bonn_2, type = 3, main = "Color shades of the University of Bonn")

}
\seealso{
\code{\link{uni_bonn_1}} for primary colors of the University of Bonn;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{caltech_pal_1}},
\code{\link{caltech_pal_2}},
\code{\link{caltech_pal_3}},
\code{\link{eth_pal_1}},
\code{\link{eth_pal_2}},
\code{\link{eth_pal_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{mpg_pal}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{uni_bonn_1}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unikn}, 2022-12-10.
}
\concept{contributed color palettes}
\keyword{datasets}
