% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_def_1.R
\docType{data}
\name{pal_signal}
\alias{pal_signal}
\title{uni.kn signal (Ampel) color palette.}
\format{An object of class \code{data.frame} with 1 rows and 3 columns.}
\usage{
pal_signal
}
\description{
\code{pal_signal} provides an additional uni.kn color palette  
as a data frame containing 3 colors (Ampel or traffic signal colors).
}
\details{
The colors are arranged as in a traffic light ("Ampel"): 
\enumerate{
\item top: red or "bad"
\item mid: yellow or "alert"
\item bot: green or "good"
}

See \url{https://www.uni-konstanz.de/en/university/news-and-media/create-online-and-print-media/corporate-design/} for details.
}
\examples{
pal_signal
dim(pal_signal)  # 1 3
pal_signal[2]    # (named) color "signal2"
pal_signal[[2]]  # color "signal2" OR "#EFDC60"

# Plotting palette:
seecol(pal_signal)

}
\seealso{
\code{\link{pal_unikn}} for the unikn default color palette with all 5 colors of \code{\link{pal_seeblau}}; 
\code{\link{pal_unikn_pref}} for a uni.kn color palette with all preferred colors; 
\code{\link{seecol}} to show and use color palettes.

Other color palettes: \code{\link{pal_bordeaux}},
  \code{\link{pal_grau}}, \code{\link{pal_karpfenblau}},
  \code{\link{pal_peach}}, \code{\link{pal_petrol}},
  \code{\link{pal_pinky}}, \code{\link{pal_seeblau}},
  \code{\link{pal_seegruen}}, \code{\link{pal_unikn_dark}},
  \code{\link{pal_unikn_light}},
  \code{\link{pal_unikn_pair}},
  \code{\link{pal_unikn_ppt}},
  \code{\link{pal_unikn_pref}},
  \code{\link{pal_unikn_web}}, \code{\link{pal_unikn}}
}
\concept{color palettes}
\keyword{datasets}
