% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Heidelberg.R
\docType{data}
\name{uni_heidelberg}
\alias{uni_heidelberg}
\title{Official colours of the University of Heidelberg, Germany}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on the
\href{https://backend.uni-heidelberg.de/de/dokumente/corporate-design-handbuch/download}{Uni Heidelberg Corporate Design}.
}
\usage{
uni_heidelberg
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{uni_heidelberg} provides the three official colours 
of the \href{https://www.uni-heidelberg.de/de}{University of Heidelberg}, Germany.
}
\details{
The 3 official colours are
\code{"Rot" (Siegel-Hintergrund)} (defined as  C20 / M100 / y90 / K0, r198 / g24 / b38),
\code{"Rot-Braun" (Siegel-Outline)} (defined as C30 / M100 / y90 / K65, r89 / g13 / b8), and
\code{"Sand" (Zusatzfarbe)} (defined as  C5 / M5 / y9 / K0, r244 / g241 / b234).

\code{uni_heidelberg} uses the RGB color definitions.
}
\examples{
uni_heidelberg
unikn::seecol(uni_heidelberg, main = "Official colours of the University of Heidelberg") 
# view colour palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colours.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2023-06-27.
}
\concept{German university color palettes}
\keyword{datasets}
