% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Edinburgh.R
\docType{data}
\name{edinburgh}
\alias{edinburgh}
\title{Primary colours of the University of Edinburgh, Scotland/UK}
\format{
An object of class \code{character} of length 11.
}
\source{
Color definitions are based on the
\href{https://gel.ed.ac.uk/foundations/colour/}{CD manual (PDF)}.
}
\usage{
edinburgh
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{edinburgh} provides the eleven primary colours 
of the \href{https://www.ed.ac.uk}{University of Edinburgh}, Scotland.
}
\details{
The 11 primary colours are
\code{"University red"} (defined as HEX: D50032, RGB: 213, 0, 50),
\code{"University blue"} (defined as HEX: 041E42, RGB: 4, 30, 66), 
\code{"Bright blue"} (defined as HEX: 007288, RGB: 0, 114, 136),
\code{"Bright pink"} (defined as HEX: D0006F, RGB: 208, 0, 111),
\code{"Purple"} (defined as HEX: 830065, RGB: 131, 0, 101),
\code{"Burgundy"} (defined as HEX: A50034, RGB: 165, 0, 52),
\code{"Dark green"} (defined as HEX: 154734, RGB: 21, 71, 52),
\code{"Jade"} (defined as HEX: 487A7B, RGB: 72, 122, 123),
\code{"Muted blue"} (defined as HEX: 004F71, RGB: 0, 79, 113),
\code{"Muted brown"} (defined as HEX: 6D4F47, RGB: 109, 79, 71), and
\code{"Spuce grey"} (defined as HEX: 333F48, RGB: 51, 63, 72).

\code{edinburgh} uses the HEX color definitions.
}
\examples{
edinburgh
unikn::seecol(edinburgh, main = "Colors of the University of Edinburgh") # view color palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colours.

Other Scottish university color palettes: 
\code{\link{dundee_background}},
\code{\link{dundee_block}},
\code{\link{dundee_core}},
\code{\link{dundee_highlight}},
\code{\link{standrews_1}},
\code{\link{standrews_2}}
}
\author{
\strong{unicol}, 2023-06-20.
}
\concept{Scottish university color palettes}
\keyword{datasets}
