% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxDoC.R
\name{umxDoC}
\alias{umxDoC}
\title{Build and run a 2-group Direction of Causation twin models.}
\usage{
umxDoC(
  name = "DOC",
  var1Indicators,
  var2Indicators,
  mzData = NULL,
  dzData = NULL,
  sep = NULL,
  causal = TRUE,
  autoRun = getOption("umx_auto_run"),
  intervals = FALSE,
  tryHard = c("no", "yes", "ordinal", "search"),
  optimizer = NULL
)
}
\arguments{
\item{name}{The name of the model (defaults to "DOC").}

\item{var1Indicators}{variables defining latent trait 1}

\item{var2Indicators}{variables defining latent trait 2}

\item{mzData}{The MZ dataframe.}

\item{dzData}{The DZ dataframe.}

\item{sep}{The separator in twin variable names, often "_T", e.g. "dep_T1". Simplifies selDVs.}

\item{causal}{whether to add the causal paths (default TRUE)}

\item{autoRun}{Whether to run the model (default), or just to create it and return without running.}

\item{intervals}{Whether to run mxCI confidence intervals (default = FALSE)}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "ordinal", "search"}

\item{optimizer}{Optionally set the optimizer (default NULL does nothing).}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}} of subclass mxModel.DOC
}
}
\description{
Testing causal claims is often difficult due to an inability to conduct experimental randomization of traits and situations to people.
When twins are available, even when measured on a single occasion, the pattern of cross-twin cross-trait correlations
can (given distinguishable modes of inheritance for the two traits) falsify causal hypotheses.

\code{umxDoC} implements a 2-group model to form latent variables for each of two traits, and allows testing whether
trait 1 causes trait 2, vice-versa, or even reciprocal causation.

The following figure shows how the DoC model appears as a path diagram (for two latent variables X and Y,
each with three indicators). Note: For pedagogical reasons, only the model for 1 twin is shown, and only one DoC pathway drawn.

\if{html}{\figure{DoC.png}{options: width="50\%" alt="Figure: Direction of Causation"}}
\if{latex}{\figure{DoC.pdf}{options: width=7cm}}
}
\details{
To be added.
}
\examples{
\dontrun{
# ========================
# = Does Rain cause Mud? =
# ========================

# ================
# = Prepare Data =
# ================
mzData = read.csv("~/Desktop/DOC/MZdata.csv")
dzData = read.csv("~/Desktop/DOC/DZdata.csv")
varNames = paste0(rep(c("a", "b"), each= 3), c(1:3))

names(mzData) = c("X", paste0(varNames, "_T1"), paste0(varNames, "_T2"), "sex_T1", "sex_T2")
names(dzData) = c("X", paste0(varNames, "_T1"), paste0(varNames, "_T2"), "sex_T1", "sex_T2")

Chol  = umxDoC(var1= paste0("a", 1:3), var2 = paste0("b", 1:3), 
			mzData= mzData, dzData= dzData, sep = "_T", causal= FALSE)
DoC   = umxDoC(var1= paste0("a", 1:3), var2 = paste0("b", 1:3),
		mzData= mzData, dzData= dzData, sep = "_T", causal= TRUE)
A2B   = umxModify(DoC, "a2b", free = TRUE, name = "A2B"); summary(A2B)
B2A   = umxModify(DoC, "b2a", free = TRUE, name = "B2A"); summary(B2A)
Recip = umxModify(DoC, c("a2b", "b2a"), free = TRUE, name = "Recip"); summary(Recip)

Chol = umxDoC(var1= paste0("SOS", 1:8), var2= paste0("Vocab", 1:10),mzData= mzData, dzData= dzData, 
			sep = "_T", causal= FALSE, auto=FALSE); Chol = mxRun(Chol)
DoC = umxDoC(var1= paste0("SOS", 1:8), var2= paste0("Vocab", 1:10), mzData= mzData, dzData= dzData,
			sep = "_T", causal= TRUE, auto=FALSE); DoC = mxRun(DoC)
A2B   = umxModify(DoC, "a2b", free = TRUE, name = "A2B", auto=F); A2B = mxRun(A2B)
B2A   = umxModify(DoC, "b2a", free = TRUE, name = "B2A", auto=F); B2A = mxRun(B2A)
Recip = umxModify(DoC, c("a2b", "b2a"), free = TRUE, name = "Recip", auto=F); Recip = mxRun(Recip)

umxCompare(Chol, c(A2B, B2A, Recip))
}

}
\references{
\itemize{
\item N.A. Gillespie and N.G. Marting (2005). Direction of Causation Models.
In \emph{Encyclopedia of Statistics in Behavioral Science}, Volume 1 pp. 496–499. Eds. Brian S. Everitt & David C. Howell
}
}
\seealso{
\itemize{
\item \code{\link[=plot.MxModelDoC]{plot.MxModelDoC()}}, \code{\link[=umxSummary.MxModelDoC]{umxSummary.MxModelDoC()}}, \code{\link[=umxModify]{umxModify()}}
}

Other Twin Modeling Functions: \code{\link{power.ACE.test}()},
  \code{\link{umxACE_cov_fixed}()},
  \code{\link{umxACEcov}()}, \code{\link{umxACEv}()},
  \code{\link{umxACE}()}, \code{\link{umxCP}()},
  \code{\link{umxGxE_window}()}, \code{\link{umxGxEbiv}()},
  \code{\link{umxGxE}()}, \code{\link{umxIP}()},
  \code{\link{umxRotate.MxModelCP}()},
  \code{\link{umxSexLim}()}, \code{\link{umxSimplex}()},
  \code{\link{umx}}
}
\concept{Twin Modeling Functions}
