% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_check_model}
\alias{umx_check_model}
\title{Check for required features in an OpenMx.}
\usage{
umx_check_model(obj, type = NULL, hasData = NULL, beenRun = NULL,
  hasMeans = NULL, checkSubmodels = FALSE, callingFn = "a function")
}
\arguments{
\item{obj}{an object to check}

\item{type}{what type the model must be, i.e., "RAM", "LISREL", etc. (defaults to not checking NULL)}

\item{hasData}{whether the model should have data or not (defaults to not checking NULL)}

\item{beenRun}{whether the model has been run or not (defaults to not checking NULL)}

\item{hasMeans}{whether the model should have a means model or not (defaults to not checking NULL)}

\item{checkSubmodels}{whether to check submodels (not implemented yet) (default = FALSE)}

\item{callingFn}{= To help user interprete error, add the name of the calling function.}
}
\value{
- boolean
}
\description{
Allows the user to straight-forwardly require a specific model type (i.e., 
"RAM", "LISREL", etc.), whether or not the model has data, if it has been run or not. 
You can also test whether is has a means model or not and (in future) test if it has submodels.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
umx_check_model(m1)
umx_check_model(m1, type = "RAM") # equivalent to umx_is_RAM()
umx_check_model(m1, hasData = TRUE)
\dontrun{
umx_check_model(m1, hasMeans = TRUE)
umx_check_model(m1, beenRun = FALSE)
}
}
\references{
- \url{https://www.github.com/tbates/umx}
}
\seealso{
Other Test: \code{\link{umx_check_OS}},
  \code{\link{umx_check_names}},
  \code{\link{umx_check_parallel}},
  \code{\link{umx_check}}, \code{\link{umx_has_CIs}},
  \code{\link{umx_has_been_run}},
  \code{\link{umx_has_means}},
  \code{\link{umx_has_square_brackets}},
  \code{\link{umx_is_MxData}},
  \code{\link{umx_is_MxMatrix}},
  \code{\link{umx_is_MxModel}}, \code{\link{umx_is_RAM}},
  \code{\link{umx_is_cov}},
  \code{\link{umx_is_endogenous}},
  \code{\link{umx_is_exogenous}},
  \code{\link{umx_is_ordered}}
}
\concept{Test}
