% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umx_aggregate}
\alias{umx_aggregate}
\title{Convenient formula-based cross-tabs & built-in summary functions}
\usage{
umx_aggregate(formula = DV ~ condition, data = NA,
  what = c("mean_sd", "n"), digits = 2, report = c("markdown",
  "html", "txt"))
}
\arguments{
\item{formula}{The aggregation formula. e.g., DV ~ condition.}

\item{data}{frame to aggregate.}

\item{what}{function to use. Default reports "mean (sd)".}

\item{digits}{to round results to.}

\item{report}{Format for the table: Default is markdown.}
}
\value{
- table
}
\description{
A common task is preparing summary tables, aggregating over some grouping factor.
Like mean and sd of age, by sex. R's \code{\link{aggregate}} function is useful and powerful, allowing
xtabs based on a formula.

umx_aggregate makes using it a bit easier. In particular, it has some common functions 
for summarising data built-in, like "mean (sd)" (the default).

\code{umx_aggregate(mpg ~ cyl, data = mtcars, what = "mean_sd")}

\tabular{ll}{
cyl        \tab mpg\cr
4 (n = 11) \tab 26.66 (4.51)\cr
6 (n = 7)  \tab 19.74 (1.45)\cr
8 (n = 14) \tab 15.1 (2.56)\cr
}
}
\examples{
# =====================================
# = Basic use, compare with aggregate =
# =====================================
aggregate(mpg ~ cyl, FUN = mean, na.rm = TRUE, data = mtcars)
umx_aggregate(mpg ~ cyl, data = mtcars)

# =============================================
# = Use different (or user-defined) functions =
# =============================================
umx_aggregate(mpg ~ cyl, data = mtcars, what = "n")
umx_aggregate(mpg ~ cyl, data = mtcars, what = function(x){sum(!is.na(x))})

# turn off markdown
umx_aggregate(mpg ~ cyl, data = mtcars, report = "txt")

# ============================================
# = More than one item on the left hand side =
# ============================================
umx_aggregate(cbind(mpg, qsec) ~ cyl, data = mtcars, digits = 3)
# Transpose table
t(umx_aggregate(cbind(mpg, qsec) ~ cyl, data = mtcars))

\dontrun{
umx_aggregate(cbind(moodAvg, mood) ~ condition, data = study1)
}
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{umx_apply}}, \code{\link{aggregate}}

Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{umxAPA}},
  \code{\link{umxEval}}, \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umxWeightedAIC}},
  \code{\link{umx_APA_model_CI}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_names}},
  \code{\link{umx_parameters}}, \code{\link{umx_print}},
  \code{\link{umx_show_fit_or_comparison}},
  \code{\link{umx_show}}, \code{\link{umx_time}},
  \code{\link{umx}}
}
\concept{Reporting Functions}
