% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxSimplex.R
\name{umxSimplex}
\alias{umxSimplex}
\title{Build and run a simplex twin model}
\usage{
umxSimplex(name = "simplex", selDVs, dzData, mzData, sep = NULL,
  equateMeans = TRUE, dzAr = 0.5, dzCr = 1, addStd = TRUE,
  addCI = TRUE, autoRun = getOption("umx_auto_run"), optimizer = NULL)
}
\arguments{
\item{name}{The name of the model (defaults to "simplex")}

\item{selDVs}{The BASENAMES of the variables to include, i.e., c(`obese`), not c(`obese_T1`, `obese_T2`)}

\item{dzData}{The DZ dataframe}

\item{mzData}{The MZ dataframe}

\item{sep}{The string preceeding the final numeric twin identifiier (often "_T")
omit suffixes in selDVs, i.e., just "dep" not c("dep_T1", "dep_T2")}

\item{equateMeans}{Whether to equate the means across twins (defaults to T)}

\item{dzAr}{The DZ genetic correlation (default = .5. Vary to examine assortative mating)}

\item{dzCr}{The DZ "C" correlation (defaults = 1. To make an ADE model, set = .25)}

\item{addStd}{Whether to add the algebras to compute a std model (default = TRUE)}

\item{addCI}{Whether to add the interval requests for CIs (default = TRUE)}

\item{autoRun}{Whether to mxRun the model (default TRUE: the estimated model will be returned)}

\item{optimizer}{Optionally set the optimizer (default NULL does nothing)}
}
\value{
- \code{\link{mxModel}}
}
\description{
THIS IS BOILER PLATE AWAITING UPDATING FOR THIS NEW FUNCTION, WHICH IS IN BETA.
}
\details{
Make a 2-group simplex twin model
The common-pathway model provides a powerful tool for theory-based decomposition of genetic
and environmental differences.

umxCP supports this with pairs of mono-zygotic (MZ) and di-zygotic (DZ) twins reared together
to model the genetic and environmental structure of multiple phenotypes
(measured behaviors).

Simplex path diagram:

\figure{simplex.png}

As can be seen, each phenotype also by default has A, C, and E influences specific to that phenotype.


The simplex model decomposes phenotypic variance
into Additive genetic, unique environmental (E) and, optionally, either
common or shared-environment (C) or non-additive genetic effects (D).

These influences are further decomposed into innovations at a given time (in the `ai`, 
`ci` and `ei` matrices), effects transmitted from previous time point (in the `at`, 
`ct`, and `et` matrices), and influences specific to a single time (`as`, `cs`, `es`).

These in turn account for variance in the phenotypes (see Figure above).


\strong{Data Input}
Currently, the umxSimplex function accepts only raw data. This may change in future versions.

\strong{Ordinal Data}
In an important capability, the model transparently handles ordinal (binary or multi-level
ordered factor data) inputs, and can handle mixtures of continuous, binary, and ordinal
data in any combination.

\strong{Additional features}
The umxSimplex function supports varying the DZ genetic association (defaulting to .5)
to allow exploring assortative mating effects, as well as varying the DZ \dQuote{C} factor
from 1 (the default for modeling family-level effects shared 100% by twins in a pair),
to .25 to model dominance effects.

\strong{Matrices and Labels in the simplex model}
A good way to see which matrices are used in umxSummary is to run an example model and plot it.

The loadings specific to each time point are contained on the diagonals of matrices 
`as`, `cs`, and `es`. So labels relevant to modifying these are of the form "as_r1c1", "as_r2c2" etc.

All the shared matrices are in the model "top". So to see the 'as' values, you can simply execute:

m1$top$as$values

The transmitted loadings are in matrices at, ct, et.

The innovations are in the matrix `ai`, `ci`, and `ei`.

Less commonly-modified matrices are the mean matrix `expMean`. This has 1 row, and the columns are laid out for each variable for twin 1, followed by each variable for twin 2.

So, in a model where the means for twin 1 and twin 2 had been equated (set = to T1), you could make them independent again with this script:

m1$top$expMean$labels[1,4:6] =  c("expMean_r1c4", "expMean_r1c5", "expMean_r1c6")
}
\examples{
data(iqdat)
mzData <- subset(iqdat, zygosity == "MZ")
dzData <- subset(iqdat, zygosity == "DZ")
nTimePoints = 4 # Number of time points
baseVarNames = paste0("IQ_age", 1:nTimePoints)
# IQ_age1 -> IQ_age1_T1, IQ_age1_T2,  etc.
m1 = umxSimplex(selDVs = baseVarNames, sep = "_T", dzData = dzData, mzData = mzData)
umxSummary(m1)
parameters(m1, patt = "^s")
m2 = umxModify(m1, regex = "as_r1c1", name = "no_as", comp = TRUE)
umxCompare(m1, m2)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{umxACE}()} for more examples of twin modeling, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEv}},
  \code{\link{umxACE}}, \code{\link{umxCP}},
  \code{\link{umxGxE_biv}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxSexLim}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE_biv}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
